import React from 'react';
import { Stack } from 'expo-router';
import { SafeAreaProvider } from 'react-native-safe-area-context';
import { StatusBar } from 'expo-status-bar';
import { AuthProvider } from '../contexts/AuthContext';
import { PostsProvider } from '../contexts/PostsContext';
import { StoriesProvider } from '../contexts/StoriesContext';
import { useTheme } from '../hooks/useTheme';

function RootLayoutContent() {
  const { colors, colorScheme } = useTheme();

  return (
    <>
      <StatusBar style={colorScheme === 'dark' ? 'light' : 'dark'} />
      <Stack screenOptions={{ headerShown: false }}>
        <Stack.Screen name="(tabs)" />
        <Stack.Screen name="settings" />
        <Stack.Screen name="creator-dashboard" />
      </Stack>
    </>
  );
}

export default function RootLayout() {
  return (
    <SafeAreaProvider>
      <AuthProvider>
        <PostsProvider>
          <StoriesProvider>
            <RootLayoutContent />
          </StoriesProvider>
        </PostsProvider>
      </AuthProvider>
    </SafeAreaProvider>
  );
}