import { User, Post, Story, MonetizationStatus, CreatorDashboardData } from '../types';

export const MOCK_USERS: User[] = [
  {
    id: 'u1',
    username: 'sarah.creator',
    displayName: 'Sarah Johnson',
    avatar: 'https://i.pravatar.cc/150?img=1',
    bio: 'Digital artist & content creator ✨\n📍 San Francisco\n🎨 Verified & Monetized',
    isVerified: true,
    isMonetized: true,
    monetizationTier: 'TIER_B',
    followersCount: 125400,
    followingCount: 892,
    postsCount: 1847,
    yesCount90d: 8500,
    noCount30d: 12,
    accountAge: 245,
    customLinks: ['https://instagram.com/sarah', 'https://shop.sarah.com'],
    merchEnabled: true,
  },
  {
    id: 'u2',
    username: 'alex.tech',
    displayName: 'Alex Rivera',
    avatar: 'https://i.pravatar.cc/150?img=2',
    bio: 'Tech reviewer & gadget enthusiast 📱\n💻 Reviews daily',
    isVerified: true,
    isMonetized: true,
    monetizationTier: 'TIER_A',
    followersCount: 89200,
    followingCount: 456,
    postsCount: 923,
    yesCount90d: 4200,
    noCount30d: 8,
    accountAge: 178,
    customLinks: [],
    merchEnabled: false,
  },
  {
    id: 'u3',
    username: 'maya.wellness',
    displayName: 'Maya Chen',
    avatar: 'https://i.pravatar.cc/150?img=3',
    bio: 'Wellness coach | Yoga instructor 🧘‍♀️\n🌱 Healthy living',
    isVerified: false,
    isMonetized: false,
    monetizationTier: undefined,
    followersCount: 2340,
    followingCount: 892,
    postsCount: 134,
    yesCount90d: 1200,
    noCount30d: 3,
    accountAge: 45,
    customLinks: [],
    merchEnabled: false,
  },
];

const generateMockPosts = (): Post[] => {
  const posts: Post[] = [];
  const captions = [
    'Beautiful sunset at the beach 🌅 #nature #photography',
    'New project launching soon! Stay tuned 🚀',
    'Coffee and creativity ☕️✨ #morning #vibes',
    'Exploring the city streets 🏙️ #urban #adventure',
    'Throwback to this amazing moment 💫',
  ];

  MOCK_USERS.forEach((user, userIdx) => {
    for (let i = 0; i < 5; i++) {
      posts.push({
        id: `p${userIdx}_${i}`,
        userId: user.id,
        user,
        type: i % 3 === 0 ? 'carousel' : 'image',
        media: i % 3 === 0 
          ? [
              `https://picsum.photos/1080/1350?random=${userIdx * 100 + i * 10 + 1}`,
              `https://picsum.photos/1080/1350?random=${userIdx * 100 + i * 10 + 2}`,
              `https://picsum.photos/1080/1350?random=${userIdx * 100 + i * 10 + 3}`,
            ]
          : [`https://picsum.photos/1080/1350?random=${userIdx * 100 + i * 10}`],
        caption: captions[i],
        location: i % 2 === 0 ? 'San Francisco, CA' : undefined,
        timestamp: new Date(Date.now() - i * 3600000 * 24),
        likesCount: Math.floor(Math.random() * 10000) + 100,
        commentsCount: Math.floor(Math.random() * 500) + 10,
        yesCount: Math.floor(Math.random() * 500) + 50,
        noCount: Math.floor(Math.random() * 20),
        isLiked: false,
        isBookmarked: false,
      });
    }
  });

  return posts;
};

export const MOCK_POSTS = generateMockPosts();

export const MOCK_STORIES: Story[] = MOCK_USERS.map((user, idx) => ({
  id: `s${idx}`,
  userId: user.id,
  user,
  media: `https://picsum.photos/1080/1920?random=${1000 + idx}`,
  type: 'image',
  timestamp: new Date(Date.now() - idx * 600000),
  isViewed: false,
}));

export const MOCK_MONETIZATION_STATUS: MonetizationStatus = {
  isEligible: true,
  tier: 'TIER_B',
  accountAgeDays: 245,
  yes90d: 8500,
  no30d: 12,
  requirementsState: {
    accountAge: true,
    yesThreshold: true,
    noThreshold: true,
    kycCompleted: true,
  },
  nextUnlocks: [],
  payoutDay: 23,
  lastPayoutAmount: 4250.50,
};

export const MOCK_CREATOR_DASHBOARD: CreatorDashboardData = {
  totalEarnings: 42850.75,
  monthlyEarnings: 4250.50,
  adRevenue: 2100.25,
  paidContentRevenue: 1500.00,
  merchRevenue: 550.25,
  tipsRevenue: 100.00,
  nextPayoutDate: new Date(2025, 10, 23),
  nextPayoutAmount: 3890.50,
};