import { Dimensions, Platform } from 'react-native';

const { width, height } = Dimensions.get('window');

export const BREAKPOINTS = {
  mobile: 0,
  tablet: 768,
  desktop: 1024,
};

export const isDesktop = width >= BREAKPOINTS.desktop;
export const isTablet = width >= BREAKPOINTS.tablet && width < BREAKPOINTS.desktop;
export const isMobile = width < BREAKPOINTS.tablet;

export const COLORS = {
  light: {
    background: '#FFFFFF',
    surface: '#FAFAFA',
    border: '#DBDBDB',
    text: '#262626',
    textSecondary: '#8E8E8E',
    primary: '#0095F6',
    error: '#ED4956',
    success: '#00BA7C',
    verified: '#0095F6',
    monetized: '#FFD700',
  },
  dark: {
    background: '#000000',
    surface: '#121212',
    border: '#262626',
    text: '#FFFFFF',
    textSecondary: '#A8A8A8',
    primary: '#0095F6',
    error: '#ED4956',
    success: '#00BA7C',
    verified: '#0095F6',
    monetized: '#FFD700',
  },
};

export const SPACING = {
  xs: 4,
  sm: 8,
  md: 12,
  lg: 16,
  xl: 24,
  xxl: 32,
};

export const TYPOGRAPHY = {
  sizes: {
    xs: 11,
    sm: 12,
    base: 14,
    lg: 16,
    xl: 18,
    xxl: 24,
    xxxl: 28,
  },
  weights: {
    regular: '400' as const,
    medium: '500' as const,
    semibold: '600' as const,
    bold: '700' as const,
  },
};

export const LAYOUT = {
  maxContentWidth: 935,
  sidebarWidth: 244,
  headerHeight: Platform.select({ web: 60, default: 44 }),
  tabBarHeight: Platform.select({ ios: 83, android: 60, default: 60 }),
  postImageHeight: Platform.select({ 
    web: isDesktop ? 600 : width, 
    default: width 
  }),
};

export const ANIMATION = {
  duration: {
    fast: 150,
    normal: 250,
    slow: 350,
  },
  easing: {
    standard: 'ease-in-out',
    decelerate: 'ease-out',
    accelerate: 'ease-in',
  },
};

export const MONETIZATION = {
  TIER_A_YES_REQUIRED: 3000,
  TIER_B_YES_REQUIRED: 5000,
  MIN_ACCOUNT_AGE_DAYS: 90,
  MAX_NO_ALLOWED_30D: 100,
  PAYOUT_DAY: 23,
  WINDOWS: {
    YES_DAYS: 90,
    NO_DAYS: 30,
  },
};