import React, { createContext, useState, ReactNode } from 'react';
import { User } from '../types';
import { MOCK_USERS } from '../constants/mockData';

interface AuthContextType {
  user: User | null;
  isAuthenticated: boolean;
  login: (username: string, password: string) => Promise<boolean>;
  logout: () => void;
}

export const AuthContext = createContext<AuthContextType | undefined>(undefined);

export function AuthProvider({ children }: { children: ReactNode }) {
  const [user, setUser] = useState<User | null>(MOCK_USERS[0]);

  const login = async (username: string, password: string): Promise<boolean> => {
    if (username === 'test@example.com' && password === '123456') {
      setUser(MOCK_USERS[0]);
      return true;
    }
    return false;
  };

  const logout = () => {
    setUser(null);
  };

  return (
    <AuthContext.Provider
      value={{
        user,
        isAuthenticated: !!user,
        login,
        logout,
      }}
    >
      {children}
    </AuthContext.Provider>
  );
}