import React, { createContext, useState, ReactNode } from 'react';
import { Story } from '../types';
import { MOCK_STORIES } from '../constants/mockData';

interface StoriesContextType {
  stories: Story[];
  markAsViewed: (storyId: string) => void;
}

export const StoriesContext = createContext<StoriesContextType | undefined>(undefined);

export function StoriesProvider({ children }: { children: ReactNode }) {
  const [stories, setStories] = useState<Story[]>(MOCK_STORIES);

  const markAsViewed = (storyId: string) => {
    setStories(prev =>
      prev.map(story =>
        story.id === storyId ? { ...story, isViewed: true } : story
      )
    );
  };

  return (
    <StoriesContext.Provider value={{ stories, markAsViewed }}>
      {children}
    </StoriesContext.Provider>
  );
}