import { useState, useEffect } from 'react';
import { Dimensions, Platform } from 'react-native';
import { BREAKPOINTS } from '../constants/theme';

export function useResponsive() {
  const [dimensions, setDimensions] = useState(() => {
    const { width, height } = Dimensions.get('window');
    return { width, height };
  });

  useEffect(() => {
    const updateDimensions = () => {
      const { width, height } = Dimensions.get('window');
      setDimensions({ width, height });
    };

    const subscription = Dimensions.addEventListener('change', updateDimensions);
    return () => subscription?.remove();
  }, []);

  const isDesktop = dimensions.width >= BREAKPOINTS.desktop;
  const isTablet = dimensions.width >= BREAKPOINTS.tablet && dimensions.width < BREAKPOINTS.desktop;
  const isMobile = dimensions.width < BREAKPOINTS.tablet;

  return {
    dimensions,
    isDesktop,
    isTablet,
    isMobile,
    breakpoint: isDesktop ? 'desktop' : isTablet ? 'tablet' : 'mobile',
  };
}