import { useState } from 'react';
import { useColorScheme } from 'react-native';
import { COLORS } from '../constants/theme';

export function useTheme() {
  const systemColorScheme = useColorScheme();
  const [colorScheme] = useState<'light' | 'dark'>(systemColorScheme || 'light');

  const colors = COLORS[colorScheme];

  return {
    colors,
    colorScheme,
    isDark: colorScheme === 'dark',
  };
}