export type SignalType = 'yes' | 'no';

export interface User {
  id: string;
  username: string;
  displayName: string;
  avatar: string;
  bio?: string;
  isVerified: boolean;
  isMonetized: boolean;
  monetizationTier?: 'TIER_A' | 'TIER_B';
  followersCount: number;
  followingCount: number;
  postsCount: number;
  yesCount90d: number;
  noCount30d: number;
  accountAge: number;
  customLinks?: string[];
  merchEnabled: boolean;
}

export interface Post {
  id: string;
  userId: string;
  user: User;
  type: 'image' | 'video' | 'carousel';
  media: string[];
  caption: string;
  location?: string;
  timestamp: Date;
  likesCount: number;
  commentsCount: number;
  yesCount: number;
  noCount: number;
  isLiked: boolean;
  isBookmarked: boolean;
  hasUserSignaled?: 'yes' | 'no';
}

export interface Story {
  id: string;
  userId: string;
  user: User;
  media: string;
  type: 'image' | 'video';
  timestamp: Date;
  isViewed: boolean;
}

export interface Comment {
  id: string;
  postId: string;
  userId: string;
  user: User;
  text: string;
  timestamp: Date;
  likesCount: number;
  isLiked: boolean;
}

export interface MonetizationStatus {
  isEligible: boolean;
  tier: 'NONE' | 'TIER_A' | 'TIER_B';
  accountAgeDays: number;
  yes90d: number;
  no30d: number;
  requirementsState: {
    accountAge: boolean;
    yesThreshold: boolean;
    noThreshold: boolean;
    kycCompleted: boolean;
  };
  nextUnlocks: string[];
  payoutDay: number;
  lastPayoutAmount?: number;
}

export interface CreatorDashboardData {
  totalEarnings: number;
  monthlyEarnings: number;
  adRevenue: number;
  paidContentRevenue: number;
  merchRevenue: number;
  tipsRevenue: number;
  nextPayoutDate: Date;
  nextPayoutAmount: number;
}